{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 10.03.98 - 14:17:53 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, MMSystem, MMUtils, MMObj,
  MMWaveIO, MMWavOut, MMDIBCv, MMOscope, MMLevel, MMLEDS, MMSpin, MMLEDLbl,
  MMWInfo, MMButton, MMPCMSUP, MMCstDlg, MMConect,MMSpectr, MMDesign,
  MMDSPObj, MMWave, MMHTimer, MMRingBf, Menus, MMHook;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    FileLabel: TLabel;
    Oscope1: TMMOscope;
    Oscope2: TMMOscope;
    MMWaveOut1: TMMWaveOut;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label14: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    SpinEdit3: TMMLEDSpin;
    SpinEdit2: TMMLEDSpin;
    SpinEdit1: TMMLEDSpin;
    GroupBox2: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label13: TLabel;
    CheckBox1: TCheckBox;
    SpinEdit6: TMMLEDSpin;
    SpinEdit7: TMMLEDSpin;
    SpinEdit4: TMMLEDSpin;
    SpinEdit5: TMMLEDSpin;
    SpinEdit8: TMMLEDSpin;
    CheckBox4: TCheckBox;
    MMLEDLabel1: TMMLEDLABEL;
    Panel3: TPanel;
    mm2: TMMLEDDigit;
    mm: TMMLEDDigit;
    ss2: TMMLEDDigit;
    ss: TMMLEDDigit;
    Colon1: TMMLEDDigit;
    Level2: TMMLevel;
    Level1: TMMLevel;
    Label12: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    MMLEDMode1: TMMLEDMode;
    Overflow1: TLabel;
    MMLEDPanel1: TMMLEDPanel;
    MMLEDPanel2: TMMLEDPanel;
    MMLEDPanel3: TMMLEDPanel;
    LED1: TMMLED;
    Label9: TLabel;
    LED2: TMMLED;
    Label10: TLabel;
    LED3: TMMLED;
    Label15: TLabel;
    LED4: TMMLED;
    Label16: TLabel;
    GroupBox3: TGroupBox;
    ExitButton: TBitBtn;
    InfoButton: TBitBtn;
    FileButton: TBitBtn;
    SpinDeviceID: TMMSpinButton;
    StartButton: TSpeedButton;
    PauseButton: TSpeedButton;
    StopButton: TBitBtn;
    MMWaveInfoEditor1: TMMWaveInfoEditor;
    Colon2: TMMLEDDigit;
    ms3: TMMLEDDigit;
    ms2: TMMLEDDigit;
    ms: TMMLEDDigit;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    ckbLoop: TCheckBox;
    MMConnector1: TMMConnector;
    CheckBox6: TCheckBox;
    Label21: TLabel;
    SpinEdit9: TMMLEDSpin;
    Label22: TLabel;
    Label23: TLabel;
    Label26: TLabel;
    LevelScale: TMMLevelScale;
    MMDesigner1: TMMDesigner;
    MMWaveFile1: TMMWaveFile;
    MMRingBuffer1: TMMRingBuffer;
    procedure FileButtonClick(Sender: TObject);
    procedure InfoButtonClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure PauseButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure DisplayDblClick(Sender: TObject);
    procedure MMWaveOut1Open(Sender: TObject);
    procedure MMWaveOut1Close(Sender: TObject);
    procedure MMWaveOut1Start(Sender: TObject);
    procedure MMWaveOut1Pause(Sender: TObject);
    procedure MMWaveOut1Restart(Sender: TObject);
    procedure MMWaveOut1Stop(Sender: TObject);
    procedure MMWaveOut1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OscopeClick(Sender: TObject);
    procedure OscopeDblClick(Sender: TObject);
    procedure LevelClick(Sender: TObject);
    procedure LevelDblClick(Sender: TObject);
    procedure OscopeGainOverflow(Sender: TObject);
    procedure LevelGainOverflow(Sender: TObject);
    procedure PcmOverflow(Sender: TObject);
    procedure RadioButtonClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure SpinEdit7Change(Sender: TObject);
    procedure SpinEdit8Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure ckbLoopClick(Sender: TObject);
    procedure MMConnector1Trigger(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure SpinEdit9Change(Sender: TObject);
    procedure SpinDeviceIDChange(Sender: TObject);
  public
    LowestDevice: integer;
    AGC: Boolean;
    OverFlow: Boolean;
    UpdateTime: Boolean;
    oMin, oSec, oMSec: Word;                { saved wave-position values }

    oldNumPeaks: integer;                            { saved level values }
    oldSpotWidth: integer;

    function  HaveDevice: Boolean;
    procedure SetNewWaveParams;
    procedure UpdateDisplay;
    procedure DrawTime;
    procedure Progress(Sender: TObject; CurByte, NumBytes: Longint;
                       Var Cancel: Boolean);
  end;

Var
  MainForm: TMainForm;

implementation

uses unit2;

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
function TMainForm.HaveDevice: Boolean;
begin
     Result := False;
     if (MMWaveOut1.NumDevs = 0) then
          Application.MessageBox('Sorry, No WaveOut device installed!',
                                 'WaveOut open error',mb_OK OR mb_IconStop)
     else Result := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SetNewWaveParams;
begin
   if not MMWaveFile1.Wave.Empty then
   begin
      { adjust the buffersize for best results }
      case Word(MMWaveFile1.Wave.SampleRate) of
           00000..15000: MMWaveOut1.BufferSize := 512;
           15001..24000: MMWaveOut1.BufferSize := 1024;
           24001..32000: MMWaveOut1.BufferSize := 2048;
           32001..48000: MMWaveOut1.BufferSize := 3072;
      end;

      case MMWaveFile1.Wave.BitLength of
              1: MMWaveOut1.BufferSize := MMWaveOut1.BufferSize div 16;
           2..4: MMWaveOut1.BufferSize := MMWaveOut1.BufferSize div 8;
           5..7: MMWaveOut1.BufferSize := MMWaveOut1.BufferSize div 4;
          9..16: MMWaveOut1.BufferSize := MMWaveOut1.BufferSize * 2;
      end;

      { make sure we do not overflow the buffer with zoom in (GPF!!) }
      SpinEdit2.MaxValue := MMWaveOut1.BufferSize div Oscope1.BytesPerScope;
   end;
   UpdateDisplay;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawTime;
Var
   Hour, Min, Sec, MSec: Word;

begin
     TimeDecode(MMWaveOut1.Position, Hour, Min, Sec, MSec);

     if (oMSec <> MSec) then
     begin
          ms.Value := MSec;
          oMSec := MSec;
     end;

     if (oSec <> Sec) then
     begin
          ss.Value := Sec;
          oSec := Sec;
     end;

     if (oMin <> Min) then
     begin
          mm.Value := Min;
          oMin := Min;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
     FileButton.Enabled := True;
     StopButton.Enabled := False;
     StartButton.Enabled := Not MMWaveFile1.Wave.Empty;
     PauseButton.Enabled := StartButton.Enabled;
     InfoButton.Enabled := StartButton.Enabled;

     UpdateTime := True;
     AGC := False;
     Overflow := False;

     MMWaveOut1.DeviceID := 0;
     { is the Wave Mapper istalled ? }
     LowestDevice := WAVE_MAPPER;                           { WAVE MAPPER }
     try
        MMWaveOut1.DeviceID := WAVE_MAPPER;
     except
         On EMMWaveOutError do LowestDevice := 0; { WAVE MAPPER not inst. }
     end;
     MMWaveOut1.DeviceID := LowestDevice;

     { set the logic for the device spinedit }
     if (MMWaveOut1.NumDevs > 1) or (LowestDevice = WAVE_MAPPER) then
     begin
          SpinDeviceId.Enabled := True;
          SpinDeviceId.MinValue := LowestDevice;
          SpinDeviceID.MaxValue := MMWaveOut1.NumDevs-1;
          SpinDeviceID.Value := MMWaveOut1.DeviceID;
     end
     else SpinDeviceId.Enabled := False;

     oMin := 0;
     oSec := 0;
     oMSec := 0;

     MMWaveFile1.Wave.OnProgress := Progress;

     SetNewWaveParams;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     MMWaveOut1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
     Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
     if UpdateTime then DrawTime;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinDeviceIDChange(Sender: TObject);
begin
     MMWaveOut1.DeviceID := SpinDeviceID.Value;
     UpdateDisplay;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DisplayDblClick(Sender: TObject);
begin
     UpdateTime := Not UpdateTime;
     Colon1.Enabled := UpdateTime;
     Colon2.Enabled := UpdateTime;
     ms.Enabled  := UpdateTime;
     ms2.Enabled := UpdateTime;
     ms3.Enabled := UpdateTime;
     ss.Enabled  := UpdateTime;
     ss2.Enabled := UpdateTime;
     mm.Enabled  := UpdateTime;
     mm2.Enabled := UpdateTime;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Open(Sender: TObject);
begin
     FileButton.Enabled := False;
     InfoButton.Enabled := False;
     SpinDeviceId.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Close(Sender: TObject);
begin
     FileButton.Enabled := True;
     InfoButton.Enabled := True;

     if (MMWaveOut1.NumDevs > 1) or (LowestDevice = WAVE_MAPPER) then
          SpinDeviceId.Enabled := True
     else SpinDeviceId.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Start(Sender: TObject);
begin
     StopButton.Enabled := True;
     StartButton.Down := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Pause(Sender: TObject);
begin
     PauseButton.Down := True;
     StopButton.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Restart(Sender: TObject);
begin
     PauseButton.Down := False;
     StartButton.Down := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Stop(Sender: TObject);
begin
     MMWaveOut1.Close;
     StopButton.Enabled := False;
     StartButton.Down := False;
     PauseButton.Down := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FileButtonClick(Sender: TObject);
begin
   MMWaveOpenDialog1.FileName := '*.wav';
   if MMWaveOpenDialog1.Execute then
   begin
      MMWaveFile1.LoadFromFile(MMWaveOpenDialog1.Filename);
      SetNewWaveParams;
      if Not MMWaveFile1.Wave.Empty then
      begin
         StartButton.Enabled := True;
         PauseButton.Enabled := True;
         InfoButton.Enabled := True;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.InfoButtonClick(Sender: TObject);
var
   aFileName: TFileName;

begin
   if MMWaveInfoEditor1.Execute then
   begin
      try
         with SaveProgress do
         begin
            lblPercent.Caption := '0 %';
            lblSize.Caption := IntToStr(MMWaveFile1.Wave.FileSize div 1024)+ ' Kb';
            lblDone.Caption := '0 Kb';
            Gauge1.Progress := 0;
            BringToFront;
            Show;
         end;

         aFileName := MMWaveFile1.Wave.FileName;
         { save changes }
         MMWaveFile1.SaveToFile(aFileName);
         { reset the wave to make sure we can reload it (same name) }
         MMWaveFile1.Wave.FreeWave;
         { reload the wave }
         MMWaveFile1.LoadFromFile(aFileName);

      finally
         SaveProgress.Close;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Progress(Sender: TObject; CurByte, NumBytes: Longint;
                             Var Cancel: Boolean);
begin
     with SaveProgress do
     begin
        Gauge1.Progress := Round((CurByte * 100.0) / NumBytes+0.5);
        lblDone.Caption := IntToStr(CurByte div 1024) + ' Kb';
        lblPercent.Caption := IntToStr(Gauge1.Progress) + ' %';
    end;
    Cancel := SaveProgress.Cancel;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StartButtonClick(Sender: TObject);
Var
   State: TMMWaveOutState;

begin
     if HaveDevice then
     begin
          try
             State := MMWaveOut1.State;
             if (wosPause in State) AND (wosPlay in State) then
                MMWaveOut1.Restart
             else MMWaveOut1.Start;

             StartButton.Down := True;

          except
             StartButton.Down := False;
             raise
          end;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PauseButtonClick(Sender: TObject);
Var
   State: TMMWaveOutState;

begin
     if HaveDevice then
     begin
          try
             State := MMWaveOut1.State;
             if Not (wosPause in State) then
                MMWaveOut1.Pause
             else if (wosPlay in State) then MMWaveOut1.Restart
             else MMWaveOut1.Stop;

          except
             PauseButton.Down := False;
             raise;
          end;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StopButtonClick(Sender: TObject);
begin
     MMWaveOut1.Stop;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeClick(Sender: TObject);
Var
   Temp: TMMOscopeKind;

begin
     if Sender = Oscope1 then
     begin
          Temp := Oscope1.Kind;
          if (Temp = okSpikes) then Temp := okDots
          else inc(Temp);
          Oscope1.Kind := Temp;
     end
     else
     begin
          Temp := Oscope2.Kind;
          if (Temp = okSpikes) then Temp := okDots
          else inc(Temp);
          Oscope2.Kind := Temp;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeDblClick(Sender: TObject);
begin
   Oscope1.Enabled := NOT Oscope1.Enabled;
   Oscope2.Enabled := NOT Oscope2.Enabled;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.LevelClick(Sender: TObject);
begin
     if (Level1.SpotWidth > 2) then
     begin
          Level1.NumPeaks   := oldNumPeaks;
          Level2.NumPeaks   := oldNumPeaks;
          Level1.SpotWidth  := oldSpotWidth;
          Level2.SpotWidth  := oldSpotWidth;
          SpinEdit8.MaxValue := 5;
          SpinEdit8.Value  := oldNumPeaks;
     end
     else
     begin
          oldSpotWidth  := Level1.SpotWidth;
          oldNumPeaks   := SpinEdit8.Value;
          SpinEdit8.MaxValue := 1;
          SpinEdit8.Value := 1;
          Level1.NumPeaks  := 1;
          Level2.NumPeaks  := 1;
          Level1.SpotWidth  := 6;
          Level2.SpotWidth  := 6;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.LevelDblClick(Sender: TObject);
begin
   Level1.Enabled := NOT Level1.Enabled;
   Level2.Enabled := NOT Level2.Enabled;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit1Change(Sender: TObject);
begin
     Oscope1.Steps := SpinEdit1.Value;
     Oscope2.Steps := SpinEdit1.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit2Change(Sender: TObject);
begin
     if (SpinEdit2.Value = 0) then
        if (Oscope1.Zoom < 0) then SpinEdit2.Value := 1
        else SpinEdit2.Value := -1;

     Oscope1.Zoom := SpinEdit2.Value;
     Oscope2.Zoom := SpinEdit2.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit3Change(Sender: TObject);
begin
     Oscope1.Gain := SpinEdit3.Value;
     Oscope2.Gain := SpinEdit3.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.LevelGainOverflow(Sender: TObject);
begin
     Overflow := True;
     if Sender = Level1 then
     begin
          LED2.Enabled := True;
          if AGC then SpinEdit5.Value := Level1.Gain-1;
     end
     else
     begin
          LED4.Enabled := True;
          if AGC then SpinEdit5.Value := Level2.Gain-1;
     end;
     Overflow1.Font.Color := clRed;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeGainOverflow(Sender: TObject);
begin
     Overflow := True;
     if Sender = Oscope1 then
     begin
          LED2.Enabled := True;
          if AGC then SpinEdit3.Value := Oscope1.Gain-1;
     end
     else
     begin
          LED4.Enabled := True;
          if AGC then SpinEdit3.Value := Oscope2.Gain-1;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PcmOverflow(Sender: TObject);
begin
     Overflow := True;
     if (Sender = Oscope1) OR (Sender = Level1)  then
        LED1.Enabled := True
     else
        LED3.Enabled := True;
     if (Sender = Level1) OR (Sender = Level2) then
             Overflow1.Font.Color := clRed;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.RadioButtonClick(Sender: TObject);
begin
     if Sender = RadioButton1 then
     begin
          Oscope1.Effect := efNone;                                                  
          Oscope2.Effect := efNone;
     end
     else if Sender = RadioButton2 then
     begin
          Oscope1.Effect := efPeak;                                                  
          Oscope2.Effect := efPeak;                                                  
     end
     else if Sender = RadioButton3 then
     begin
          Oscope1.Effect := efSplit;                                                 
          Oscope2.Effect := efSplit;                                                 
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.UpdateDisplay;
begin           
     if (MMWaveOut1.NumDevs = 0) then MMLEDLabel1.Caption := 'NO DEVICE INSTALLED!'      
     else MMLEDLabel1.Caption := UpperCase(MMWaveOut1.ProductName);

     MMLEDPanel3.Value := MMWaveOut1.NumBuffers;

     if Not MMWaveFile1.Wave.Empty then
     begin
          MMLEDPanel1.Enabled := True;
          MMLEDPanel2.Enabled := True;
          MMLEDMode1.Enabled := True;
          MMLEDPanel1.Value := MMWaveFile1.Wave.SampleRate;
          MMLEDPanel2.Value := MMWaveFile1.Wave.BitLength;
          MMLEDMode1.Mode := MMWaveFile1.Wave.Mode;

          FileLabel.Caption := ExtractFileName(MMWaveFile1.Wave.FileName) +
                               ' - ' + MMWaveFile1.Wave.FormatString;
     end
     else
     begin
          MMLEDPanel1.Enabled := False;
          MMLEDPanel2.Enabled := False;
          MMLEDMode1.Enabled := False;
          FileLabel.Caption := 'No Wave-File selected';
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox1Click(Sender: TObject);
begin
     Level1.Enabled := CheckBox1.Checked;
     Level2.Enabled := CheckBox1.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox4Click(Sender: TObject);
begin
     Level1.ActiveDoted := NOT Level1.ActiveDoted;
     Level2.ActiveDoted := NOT Level2.ActiveDoted;
     Level1.InactiveDoted := NOT Level1.InactiveDoted;
     Level2.InactiveDoted := NOT Level2.InactiveDoted;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit4Change(Sender: TObject);
begin
     Level1.PeakSpeed := SpinEdit4.Value;
     Level2.PeakSpeed := SpinEdit4.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit5Change(Sender: TObject);
begin
     Level1.Gain := SpinEdit5.Value;                                           
     Level2.Gain := SpinEdit5.Value;        
end;
 
{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit6Change(Sender: TObject);
begin
     Level1.PeakDelay := SpinEdit6.Value;
     Level2.PeakDelay := SpinEdit6.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit7Change(Sender: TObject);
begin
     Level1.Decay := SpinEdit7.Value;
     Level2.Decay := SpinEdit7.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit8Change(Sender: TObject);
begin
     Level1.NumPeaks := SpinEdit8.Value;
     Level2.NumPeaks := SpinEdit8.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox6Click(Sender: TObject);
begin
   Level1.LogAmp := not CheckBox6.Checked;
   Level2.LogAmp := not CheckBox6.Checked;
   LevelScale.LogAmp := not CheckBox6.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit9Change(Sender: TObject);
begin
   Level1.Sensitivy := -SpinEdit9.Value;
   Level2.Sensitivy := -SpinEdit9.Value;
   LevelScale.Sensitivy := -SpinEdit9.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckbLoopClick(Sender: TObject);
begin
   MMWaveOut1.Looping := ckbLoop.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMConnector1Trigger(Sender: TObject);
begin
   { we use OnTrigger only to reset the Overflow's }
   if Overflow then
   begin
      LED1.Enabled := False;
      LED2.Enabled := False;
      LED3.Enabled := False;
      LED4.Enabled := False;
      Overflow1.Font.Color := clBlack;
      Overflow := False;
   end;
end;

end.
